using System;
using System.Reflection;
using System.Diagnostics;
using System.Collections;
using System.IO;
using System.Collections.Specialized;
using System.Collections.Generic;
using System.Xml;

[assembly: ObfuscateAssembly(true, StripAfterObfuscation=true)]

namespace CSharpRecipes
{
	public class Reflection
    {
        #region 13.1 Odczytywanie listy podzespow zalenych
        public static void ListImportedAssemblies()
		{
            string file = GetProcessPath();
			
			//ProcessModuleCollection pmc = curProc.Modules;
			//foreach (ProcessModule pm in pmc)
			//{
			//    Console.WriteLine("ModuleName: " + pm.ModuleName);
			//    Console.WriteLine("FileName: " + pm.FileName);
			//    Console.WriteLine("ModuleName: " + pm.FileVersionInfo.FileName);
			//}

            List<string> assemblies = new List<string>();
			Reflection.BuildDependentAssemblyList(file,assemblies);
			Console.WriteLine("Podzesp {0} posiada nastpujce drzewo zalenoci:\r\n",file);
			foreach(string name in assemblies)
			{
				Console.WriteLine("\t{0}\r\n",name);
			}
		}

		public static string[] BuildDependentAssemblyList(string path, 
			List<string> assemblies)
		{
			// lista podzespow wymaganych przez podzesp pocztkowy
			if(assemblies == null)
				assemblies = new List<string>();

			// czy podzesp zosta uwzgldniony ju wczeniej?
			if(assemblies.Contains(path)==true)
				return (new string[0]);

            try
            {
                Assembly asm = null;
                // sprawdzenie w cigu znakw obecnoci separatorw cieki
                // aby sprawdzi, czy jest to nazwa, czy cieka dostpu
                if ((path.IndexOf(Path.DirectorySeparatorChar, 0, path.Length) != -1) ||
                    (path.IndexOf(Path.AltDirectorySeparatorChar, 0, path.Length) != -1))
                {
                    // zaadowanie podzespou wskazywanego przez ciek
                    asm = Assembly.ReflectionOnlyLoadFrom(path);
                }
                else
                {
                    // sprawdzenie podzespou o podanej nazwie
                    asm = Assembly.ReflectionOnlyLoad(path);
                }
                // dodanie podzespou do listy
                if (asm != null)
                {
                    assemblies.Add(path);
                }
                // odczytanie importowanych podzespow
                AssemblyName[] imports = asm.GetReferencedAssemblies();
                // iteracja
                foreach (AssemblyName asmName in imports)
                {
                    // rekurencyjne wywoywanie podzespou, aby odczyta nowe moduy,
                    // do ktrych ten podzesp si odwouje
                    BuildDependentAssemblyList(asmName.FullName, assemblies);
                }
            }
            catch (FileLoadException fle)
            {
                // informacja o wyjtku...
                Console.WriteLine(fle);
            }

            string[] temp = new string[assemblies.Count];
            assemblies.CopyTo(temp, 0);
            return (temp);
		}

		#endregion 

        #region 13.2 Odczytywanie listy eksportowanych typw
        public static void ListExportedTypes()
		{
            string file = GetProcessPath();
            ListExportedTypes(file);
		}

		public static void ListExportedTypes(string path)
		{
			// zaadowanie podzespou
			Assembly asm = Assembly.LoadFrom(path);
			Console.WriteLine("Podzesp: {0} importuje:",path);
			// odczytanie eksportowanych typw
			Type[] types = asm.GetExportedTypes();
			foreach (Type t in types)
			{
				Console.WriteLine ("\tTyp eksportowany: {0}",t.FullName);
			}
		}

		#endregion 

        #region 13.3 Odnajdywanie metod pokrytych
        public abstract class BaseOverrides
		{
			public abstract void Foo(string str, int i);

			public abstract void Foo(long l, double d, byte[] bytes);
		}

		public class DerivedOverrides : BaseOverrides
		{
			public override void Foo(string str, int i)
			{
			}

			public override void Foo(long l, double d, byte[] bytes)
			{
			}
		}

        private static string GetProcessPath()
        {
            // ustalenie cieki, aby w przypadku, gdy uruchomienie nastpio pod kontrol debuggera,
            // otrzyma oryginalny plik
            string processName = Process.GetCurrentProcess().MainModule.FileName;
            int index = processName.IndexOf("vshost");
            if (index != -1)
            {
                string first = processName.Substring(0, index);
                int numChars = processName.Length - (index + 7);
                string second = processName.Substring(index + 7, numChars);

                processName = first + second;
            }
            return processName;
        }

		public static void FindOverriddenMethods()
		{
            Process current = Process.GetCurrentProcess();
            // odczytanie cieki biecego moduu
            string path = current.MainModule.FileName;

			// przypadek atwiejszy
			FindMethodOverrides(path,"CSharpRecipes.Reflection+DerivedOverrides");

            // przypadek z sygnatur FindMethodOverrides
			FindMethodOverrides(path, 
				"CSharpRecipes.Reflection+DerivedOverrides", 
				"Foo", 
				new Type[3] {typeof(long), typeof(double), typeof(byte[])});
		}

		public static void FindMethodOverrides(string asmPath, string typeName)
		{
			Assembly asm = Assembly.LoadFrom(asmPath);
			Type type = asm.GetType(typeName);
            FindMethodOverrides(type);
        }

        public static void FindMethodOverrides(Type asmType)
        {
			Console.WriteLine("---[" + asmType.FullName + "]---");

			// odczytanie metod, ktre pasuj do podanego typu
			MethodInfo[] methods = asmType.GetMethods(BindingFlags.Instance | 
				BindingFlags.NonPublic | BindingFlags.Public | 
				BindingFlags.DeclaredOnly);
			foreach (MethodInfo method in methods)
			{
				Console.WriteLine("Metoda bieca:  " + method.ToString());

				// odczytanie metody bazowej
				MethodInfo baseDef = method.GetBaseDefinition();
				if (baseDef != method)
				{
					Console.WriteLine("Pena nazwa typu bazowego:  " + 
						baseDef.DeclaringType.FullName);
					Console.WriteLine("Metoda bazowa:  " + baseDef.ToString());

					// odczytanie listy typw podanej metody
					Type[] paramTypes = new Type[method.GetParameters().Length];
					int counter = 0;
					foreach (ParameterInfo param in method.GetParameters())
					{
						paramTypes[counter] = param.ParameterType;
						Console.WriteLine("\tParametr {0}: {1}",
							param.Name,param.ParameterType.ToString());
						counter++;
					}
				}
				Console.WriteLine();
			}
		}

		public static void FindMethodOverrides(string asmPath, string typeName, 
			string methodName, Type[] paramTypes)
		{
			Console.WriteLine("Dla [Typu] Metody:  [" + typeName + "] " + methodName);

			Assembly asm = Assembly.ReflectionOnlyLoadFrom(asmPath);
			Type type = asm.GetType(typeName,true,true);
			MethodInfo method = type.GetMethod(methodName, paramTypes);
            FindMethodOverrides(method, paramTypes);
        }

        public static void FindMethodOverrides(MethodInfo method, Type[] paramTypes)
        {
			if (method != null)
			{
				MethodInfo baseDef = method.GetBaseDefinition();
				if (baseDef != method)
				{
					Console.WriteLine("Pena nazwa typu bazowego:  " + 
						baseDef.DeclaringType.FullName);
					Console.WriteLine("Metoda bazowa:  " + baseDef.ToString());

                    foreach (ParameterInfo param in baseDef.GetParameters())
                    {
						// wywietlenie dostpnych parametrw
						Console.WriteLine("\tParametr {0}: {1}",
							param.Name,param.ParameterType.ToString());
					}
					// znaleziono metod
                    Console.WriteLine("Znaleziono metod!");
				}
                Console.WriteLine();
			}			
		}

		#endregion 

        #region 13.4 Odnajdywanie skadowych w podzespole
        public static void FindMembersInAssembly()
		{
            string file = GetProcessPath();
            FindMemberInAssembly(file, "FindMembersInAssembly");
		}

		public static void FindMemberInAssembly(string asmPath, string memberName)
		{
			Assembly asm = Assembly.LoadFrom(asmPath);
			foreach(Type asmType in asm.GetTypes())
			{
				// najpierw sprawdzenie skadowych statycznych
				MemberInfo[] members = asmType.GetMember(memberName, MemberTypes.All, 
					BindingFlags.Public | BindingFlags.NonPublic |
					BindingFlags.Static);

				if(members.Length == 0)
				{
					// sprawdzenie skadowych egzemplarza
					members = asmType.GetMember(memberName, MemberTypes.All, 
						BindingFlags.Public | BindingFlags.NonPublic |
						BindingFlags.Instance);
				}

				foreach (MemberInfo member in members)
				{
					Console.WriteLine("Znaleziono " + member.MemberType + ":  " + 
						member.ToString() + " w " + 
						member.DeclaringType.FullName);
				}
			}
		}

		#endregion 

        #region 13.5 Odnajdywanie skadowych w interfejsie
        public interface IFindMe
		{
			void FindMethod(); 
		}

		public static void FindMembersInInterface()
		{
            string file = GetProcessPath();
            FindIFaceMemberInAssembly(file, "FindMethod");
			FindIFaceMemberInAssembly(file,"FindMethod","CSharpRecipes.Reflection+IFindMe");
		}

		public static void FindIFaceMemberInAssembly(string asmPath, string memberName)
		{
            // Zdelegowanie do przecionej metody FindIFaceMemberInAssembly
            // przekazujc jako interfaceName symbol wieloznaczny
			FindIFaceMemberInAssembly(asmPath, memberName, "*");
		}

		public static void FindIFaceMemberInAssembly(string asmPath, string memberName, 
			string interfaceName)
		{
			Assembly asm = Assembly.LoadFrom(asmPath);
			foreach(Type asmType in asm.GetTypes())
			{
				if (asmType.IsInterface &&
					(asmType.FullName.Equals(interfaceName) || 
					interfaceName.Equals("*")))
				{
					MemberInfo[] members = asmType.GetMember(memberName, MemberTypes.All, 
						BindingFlags.Instance | BindingFlags.NonPublic | 
						BindingFlags.Public | BindingFlags.Static |
						BindingFlags.IgnoreCase);

                    if (members.Length > 0)
                    {
						foreach(MemberInfo iface in members) 							
						{
							Console.WriteLine("Znaleziono skadow {0}.{1}",
								asmType.ToString(),iface.ToString());
						}
					}
				}
			}
		}

		#endregion 

        #region 13.6 Ustalanie i odczytywanie typw zagniedonych znajdujcych si w podzespole
        public static void ObtainNestedTypes()
		{
			Process curProc = Process.GetCurrentProcess();
			string file = curProc.MainModule.FileName;
			DisplayNestedTypes(file);
		}

		public static void DisplayNestedTypes(string asmPath)
		{
			bool output = false;
			string line;
			Assembly asm = Assembly.LoadFrom(asmPath);
			foreach(Type asmType in asm.GetTypes())
			{
				if (!asmType.IsEnum && !asmType.IsInterface)
				{
					line = asmType.FullName + " zawiera:\n" ;
					output = false;

					// Odczytanie wszystkich typw zagniedonych
					Type[] nestedTypes = asmType.GetNestedTypes(
						BindingFlags.Public |
						BindingFlags.NonPublic);

					// zczenie informacji o typach zagniedonych
					foreach (Type t in nestedTypes)
					{
						line += "   " + t.FullName + "\n";
						output = true;
					}
					if (output)
						Console.WriteLine(line);
				}
			}
		}

		#endregion 

        #region 13.7 Wywietlanie hierarchii dziedziczenia typu
        public static void DisplayInheritanceChain()
		{
			DisplayInheritanceHierarchyType();
		}

		public static void DisplayInheritanceChain(string asmPath)
		{
			Assembly asm = Assembly.LoadFrom(asmPath);
			foreach(Type asmType in asm.GetTypes())
			{
                DisplayInheritanceChain(asmType);
			}
		}

        public static void DisplayInheritanceChain(Type asmType)
        {
            // iteracja przez wszystkie typy bazowe
            Console.WriteLine("Typ wywiedziony: " + asmType.FullName);
            Console.WriteLine("Lista typw bazowych: " + GetBaseTypeList(asmType));
            Console.WriteLine();
        }

        public static void DisplayInheritanceChain(string asmPath, string baseType)
        {
            Assembly asm = Assembly.LoadFrom(asmPath);
            DisplayInheritanceChain(asm, baseType);
        }

        public static void DisplayInheritanceChain(Assembly asm, string baseType)
        {
            string typeHierarchy = GetBaseTypeList(asm.GetType(baseType));
            Console.WriteLine(typeHierarchy);
        }

		private static string GetBaseTypeList(Type type)
		{
			if (type != null)
			{
                // rekurencyjne wywoanie metody
				string baseTypeName = GetBaseTypeList(type.BaseType);
				if (baseTypeName.Length <= 0)
				{
					return (type.Name);
				}
				else
				{
					return (baseTypeName + "<-" + type.Name);
				}
			}
			else
			{
				return ("");
			}
		}

		public static void DisplayTypeHierarchy(string asmPath,string baseType)
		{
			Assembly asm = Assembly.LoadFrom(asmPath);
			string typeHierarchy = GetBaseTypeList(asm.GetType(baseType));
			Console.WriteLine(typeHierarchy);
		}

		public static void DisplayInheritanceHierarchyType()
		{
			Process current = Process.GetCurrentProcess();
			// odczytanie cieki biecego moduu
			string asmPath = current.MainModule.FileName;
			// konkretny typ
			DisplayTypeHierarchy(asmPath,"CSharpRecipes.Reflection+DerivedOverrides");
			// wszystkie typy w podzespole
			DisplayInheritanceChain(asmPath);     
		}
		#endregion 

        #region 13.8 Odnajdywanie podklas typu
        public static void FindSubclasses()
		{
			FindSubclassOfType();
		}

		public static Type[] GetSubClasses(string asmPath, Type baseClassType)
		{
			Assembly asm = Assembly.LoadFrom(asmPath);
            return (GetSubClasses(asm, baseClassType));
        }

        public static Type[] GetSubClasses(Assembly asm, Type baseClassType)
        {
			List<Type> subClasses = new List<Type>();

			foreach(Type type in asm.GetTypes())
			{
				if (type.IsSubclassOf(baseClassType))
				{
					subClasses.Add(type);
				}
			}

			return (subClasses.ToArray());
		}

		public static void FindSubclassOfType()
		{
            Assembly asm = Assembly.GetExecutingAssembly();
			Type type = Type.GetType("CSharpRecipes.Reflection+BaseOverrides");
			Type[] subClasses = GetSubClasses(asm, type);
            
			// wypisanie podklas dla typu
			if(subClasses.Length > 0)
			{
				Console.WriteLine("{0} posiada podklas o nazwie:",type.FullName);
				foreach(Type t in subClasses)
				{
					Console.WriteLine("\t{0}",t.FullName);
				}
			}
		}

		#endregion 

        #region 13.9 Odnajdywanie w podzespole wszystkich typw, ktre mona serializowa
        public static void FindSerializableTypes()
		{
			FindSerializable();
		}


		public static void FindSerializable()
		{
            Assembly asm = Assembly.GetExecutingAssembly();
            Type[] serializable = GetSerializableTypeNames(asm);
			// wywietlenie listy typw podlegajcych serializacji, znajdujcych si w podzespole
			if(serializable.Length > 0)
			{
				Console.WriteLine("{0} posiada nastpujce typy podlegajce serializacji:",asm.Location);
				foreach(Type t in serializable)
				{
					Console.WriteLine("\t{0}",t.FullName);
				}
			}
		}

		public static Type[] GetSerializableTypeNames(Assembly asm)
		{
			List<Type> serializableTypes = new List<Type>();

			// sprawdzenie wszystkich typw w podzespole
			foreach(Type type in asm.GetTypes())
			{
				if ((type.Attributes & TypeAttributes.Serializable) == 
					TypeAttributes.Serializable)
				{
					// dodanie nazwy typu podlegajcego serializacji
					serializableTypes.Add(type);
				}
			}

			return (serializableTypes.ToArray());
		}
		#endregion 

        #region 13.10 Filtrowanie danych w trakcie odczytywania skadowych
        #region Pola
        int i = 0;
		public int pi = 0;
		static int si = 0;
		public static int psi = 0;
		object o = null;
		public object po = null;
		static object so = null;
		public static object pso = null;
		#endregion

		#region Konstruktory
		static Reflection()
		{
			si++;
			psi = 0;
			so = new Object();
			pso = new Object();
		}

		Reflection()
		{
			i = 0;
			pi = 0;
			o = new Object();
			po = new Object();
		}

		public Reflection(int index)
		{
			i = index;
			pi = index;
			o = new Object();
			po = new Object();
		}
		#endregion

		
		public static void FilterOutput()
		{
			FilteringOutputObtainingMembers();
		}

		public static void FilteringOutputObtainingMembers()
		{
			Type reflection = typeof(Reflection);
			ConstructorInfo[] constructors = 
				reflection.GetConstructors(BindingFlags.Public |
				BindingFlags.NonPublic |
				BindingFlags.Instance | 
				BindingFlags.Static);

			Console.WriteLine("Wyszukiwanie wszystkich konstruktorw");
			foreach(ConstructorInfo c in constructors)
			{
				Console.WriteLine("\tZnaleziono konstruktor {0}",c.Name);
			}

			constructors = 
				reflection.GetConstructors(BindingFlags.Public | 
				BindingFlags.Instance);
			Console.WriteLine("Wyszukiwanie publicznych konstruktorw egzemplarza");
			foreach(ConstructorInfo c in constructors)
			{
                Console.WriteLine("\tZnaleziono konstruktor {0}", c.Name);
			}

			constructors = 
				reflection.GetConstructors(BindingFlags.NonPublic |
				BindingFlags.Instance | 
				BindingFlags.Static);
            Console.WriteLine("Wyszukiwanie konstruktorw niepublicznych");
			foreach(ConstructorInfo c in constructors)
			{
                Console.WriteLine("\tZnaleziono konstruktor {0}", c.Name);
			}

			FieldInfo[] fields = 
				reflection.GetFields(BindingFlags.Static | 
				BindingFlags.Public);
			Console.WriteLine("Wyszukiwanie pl publicznych i statycznych");
			foreach(FieldInfo f in fields)
			{
				Console.WriteLine("\tZnaleziono pole {0}",f.Name);
			}

			fields = 
				reflection.GetFields(BindingFlags.Public |
				BindingFlags.Static |
				BindingFlags.Instance);
            Console.WriteLine("Wyszukiwanie pl publicznych");
			foreach(FieldInfo f in fields)
			{
                Console.WriteLine("\tZnaleziono pole {0}", f.Name);
			}

			fields = 
				reflection.GetFields(BindingFlags.NonPublic |
				BindingFlags.Static );
            Console.WriteLine("Wyszukiwanie niepublicznych pl statycznych");
			foreach(FieldInfo f in fields)
			{
                Console.WriteLine("\tZnaleziono pole {0}", f.Name);
			}
		}
		#endregion 

        #region 13.11 Dynamiczne wywoywanie skadowych
        public static void DynamicInvocation()
		{
            TestDynamicInvocation(@"..\..\SampleClassLibrary\SampleClassLibraryTests.xml",
                                  @"SampleClassLibrary.dll");
		}

		public static void TestDynamicInvocation(string xmlFile, string path)
		{
			// wczytanie z pliku XML nazw metod, ktre naley uruchomi
			XmlDocument doc = new XmlDocument();
			doc.Load(xmlFile);

			// wczytanie metod testowych do uruchomienia
			XmlNodeList nodes = doc.SelectNodes(@"Tests/Test");

			// uruchomienie kadej metody testowej
			foreach(XmlNode node in nodes)
			{
                // odczytanie nazwy typu z atrybutu className wza Test
                string typeName = node.Attributes.GetNamedItem("className").Value;

                // odczytanie nazwy metody z atrybutu methodName wza Test
                string methodName = node.Attributes.GetNamedItem("methodName").Value;

                // odczytanie typw wszystkich parametrw
                int index = 0;
                object[] parameters = new object[node.ChildNodes.Count];
                foreach (XmlNode n in node.ChildNodes)
                {
                    parameters[index] = n.InnerText;
                    index++;
                }
                
				object obj = InvokeMethod(path, typeName, methodName,node.ChildNodes.Count, parameters);	

				// wywietlenie danych wynikowych
				Console.WriteLine("\tObiekt wynikowy: " + obj);
                Console.WriteLine("\tObiekt wynikowy: " + obj.GetType().FullName);
			}
		}

		public static object InvokeMethod(string asmPath, string typeName,
                                          string methodName, int paramCount,
                                          object[] parameters) 
		{
			// zaadowanie podzespou
			Assembly asm = Assembly.LoadFrom(asmPath);

            // utworzenie odpowiedniego typu
			Type dynClassType = asm.GetType(typeName, true, false);

			// utworzenie egzemplarza typu i sprawdzenie, e typ istnieje
			object dynObj = Activator.CreateInstance(dynClassType);
			if (dynObj != null) 
			{
				// sprawdzenie, czy metoda istnieje i odczytanie jej obiektu MethodInfo
				MethodInfo invokedMethod = dynClassType.GetMethod(methodName);
				if (invokedMethod != null)
				{
					// utowrzenie listy parametrw dla metod wywoywanych dynamicznie
					int index = 0;

					// dodanie kadego parametru do listy
					foreach(object parameter in parameters)
					{
						// odczytanie typu parametru
						Type paramType = 
							invokedMethod.GetParameters()[index].ParameterType;

						// konwersja wartoci na odpowiedni typ i przypisanie jej
						parameters[index] = 
							Convert.ChangeType(parameter,paramType);
						index++;
					}
            
					// wywoanie metody z parametrami
					object retObj = invokedMethod.Invoke(dynObj, parameters);
					// zwrcenie obiektu wynikowego
					return (retObj);
				}
			}

			return (null);
		}
		#endregion 

        #region 13.12 Definiowanie wskazwek dla zaciemniaczy kodu
        [Obfuscation(ApplyToMembers = true)]
		public static void TestObfuscate() {}
		#endregion
				
		#region 13.13 Ustalanie, czy typ lub metoda ma charakter oglny

// ms-help://MS.VSCC.v80/MS.MSDNQTR.v80.en/MS.MSDN.v80/MS.NETDEVFX.v20.en/cpref/html/P_System_Type_ContainsGenericParameters.htm
// ms-help://MS.VSCC.v80/MS.MSDNQTR.v80.en/MS.MSDN.v80/MS.VisualStudio.v80.en/dv_fxadvance/html/f93b03b0-1778-43fc-bc6d-35983d210e74.htm
// ms-help://MS.VSCC.v80/MS.MSDNQTR.v80.en/MS.MSDN.v80/MS.VisualStudio.v80.en/dv_fxadvance/html/a0c3c0c5-8178-4673-8107-9fdde780a669.htm


		public static void TestIsGeneric()
		{
			// zaadowanie podzespou
			Assembly asm = Assembly.GetExecutingAssembly();
			
			//foreach (Type tp in asm.GetTypes())
			//{
			//    if (tp.FullName.StartsWith("CSharpRecipes.DataStructsAndAlgorithms+"))
			//        Console.WriteLine("Name == " + tp.FullName);
			//}
			//Console.WriteLine();
			//Console.WriteLine();
			
			// odczytanie typu
			Type t = typeof(CSharpRecipes.DataStructsAndAlgorithms.PriorityQueue<int>);

			bool genericType = IsGenericType(t);
			
			bool genericMethod = false;
			foreach (MethodInfo mi in t.GetMethods())
				genericMethod = IsGenericMethod(mi);
			GetGenericMemberInfo(t);
		}
		
		public static bool IsGenericType(Type type)
		{
			Console.WriteLine("Typ posiada argumenty oglne: {0}", type.IsGenericType);
			
			return (type.IsGenericType);
		}
		
		public static bool IsGenericMethod(MethodInfo mi)
		{
			Console.WriteLine("Nazwa metody: {0}", mi.Name);
			Console.WriteLine("Metoda posiada argumenty oglne: {0}", mi.IsGenericMethod);
			
			return (mi.IsGenericMethod);
		}
		
		public static void GetGenericMemberInfo(Type t)
		{

            Console.WriteLine("Typ posiada argumenty oglne: {0}", t.IsGenericType);
			Console.WriteLine("Typ definiuje typ oglny: {0}", t.IsGenericTypeDefinition);

			Console.WriteLine("Pena nazwa typu: {0}", t.FullName);
			Console.WriteLine("Typ posiada parametry oglne: {0}", t.ContainsGenericParameters);
			Console.WriteLine("Typ jest parametrem oglnym: {0}", t.IsGenericParameter);
			if (t.IsGenericParameter)
			{
				Console.WriteLine("Nazwa metody deklarujcej typ: {0}", t.DeclaringMethod.Name);
				Console.WriteLine("Atrybuty oglnych parametrw typu: {0}", t.GenericParameterAttributes);
				Console.WriteLine("Pozycja oglnych parametrw typu: {0}", t.GenericParameterPosition);
				foreach (Type innerType in t.GetGenericParameterConstraints())
					Console.WriteLine("\tWarto GetGenericParameterConstraints().FullName typu: {0}", innerType.FullName);
			}
			foreach (Type innerType in t.GetGenericArguments())
				Console.WriteLine("\tWarto GetGenericArguments().FullName typu: {0}", innerType.FullName);
			Console.WriteLine("Warto GetGenericTypeDefinition().FullName typu: {0}", t.GetGenericTypeDefinition().FullName);
			Console.WriteLine("Nazwa typu: {0}", t.Name);
		}
		#endregion

        #region 13.14 Odczytywanie manifestu zasobw w kodzie rdowym
        public static void TestManifestResourceInfo()
		{
            string file = GetProcessPath();

			DisplayManifestResourceInfo(file);
		}
		
		public static void DisplayManifestResourceInfo(string asmPath)
		{
			Assembly asm = Assembly.LoadFrom(asmPath);

			foreach (string resName in asm.GetManifestResourceNames())
			{
				Console.WriteLine("\r\nNazwa zasobu: " + resName);

				ManifestResourceInfo mri = asm.GetManifestResourceInfo(resName);
				Console.WriteLine("\rNazwa pliku: " + mri.FileName);
				Console.WriteLine("\rLokalizacja zasobu: " + mri.ResourceLocation);
				if (mri.ReferencedAssembly != null)
					Console.WriteLine("\rUywany podzesp: " + mri.ReferencedAssembly.FullName);
			}
		}
		#endregion

        #region 13.15 Odczytywanie informacji o zmiennych lokalnych
        public static void TestGetLocalVars()
		{
            string file = GetProcessPath();

            Process current = Process.GetCurrentProcess();

            // odczytanie cieki dostpu do biecego moduu
            string path = current.MainModule.FileName;

			// odczytanie informacji o wszystkich zmiennych lokalnych metody CSharpRecipes.Reflection.GetLocalVars
            System.Collections.ObjectModel.ReadOnlyCollection<LocalVariableInfo> vars = (System.Collections.ObjectModel.ReadOnlyCollection<LocalVariableInfo>)GetLocalVars(file, "CSharpRecipes.Reflection", "GetLocalVars");
		}

		public static System.Collections.ObjectModel.ReadOnlyCollection<LocalVariableInfo> GetLocalVars(string asmPath, string typeName, string methodName)
		{
			Assembly asm = Assembly.LoadFrom(asmPath);
			Type asmType = asm.GetType(typeName);
			MethodInfo mi = asmType.GetMethod(methodName);
			MethodBody mb = mi.GetMethodBody();

			System.Collections.ObjectModel.ReadOnlyCollection<LocalVariableInfo> vars = (System.Collections.ObjectModel.ReadOnlyCollection<LocalVariableInfo>)mb.LocalVariables;
			
			// wywietlenie informacji o kadej zmiennej lokalnej
			foreach (LocalVariableInfo lvi in vars)
			{
				Console.WriteLine("IsPinned: " + lvi.IsPinned);
				Console.WriteLine("LocalIndex: " + lvi.LocalIndex);
				Console.WriteLine("LocalType.Module: " + lvi.LocalType.Module);
				Console.WriteLine("LocalType.FullName: " + lvi.LocalType.FullName);
				Console.WriteLine("ToString(): " + lvi.ToString());
			}
			
			return (vars);
		}
		#endregion

		#region 13.16 Tworzenie typu oglnego
        public static void TestCreateMultiMap()
        {
            Assembly asm = Assembly.LoadFrom("C:\\CSharpRecipes\\bin\\Debug\\CSharRecipes.exe");            
            CreateMultiMap(asm);
        }

		public static void CreateMultiMap(Assembly asm)
		{
			// pobranie typu, ktry ma zosta utworzony
			Type typeToConstruct = Type.GetType("CSharpRecipes.DataStructsAndAlgorithms+MultiMap`2");
			// pobranie argumentw typw, z ktrymi naley utworzy typ
			Type[] typeArguments = new Type[2] {Type.GetType("System.Int32"), Type.GetType("System.String")};
			// dowizanie argumentw typw do typu oglnego
			Type newType = typeToConstruct.MakeGenericType(typeArguments);
			// utworzenie typu
			DataStructsAndAlgorithms.MultiMap<int, string> mm = (DataStructsAndAlgorithms.MultiMap<int, string>)Activator.CreateInstance(newType);
			
			// sprawdzenie dziaania nowo utworzonego typu
			Console.WriteLine("Warto Count == " + mm.Count);
			mm.Add(1, "test1");
            Console.WriteLine("Warto Count == " + mm.Count);
		}
		#endregion
		
		#region 13.17 BONUS -- Dostp do MSIL za porednictwem odzwierciedlania
		public static void TestGetIL()
		{
            string file = GetProcessPath();

			byte[] IL = GetIL(file, "CSharpRecipes.Reflection", "DynamicInvocation");

			foreach (byte b in IL)
			{
				Console.WriteLine(string.Format("{0,00:00}", b));
				//Console.WriteLine(b.ToString("X"));
			}

			ResolveMember(IL);
		}

		public static byte[] GetIL(string asmPath, string typeName, string methodName)
		{
			Assembly asm = Assembly.LoadFrom(asmPath);
			Type asmType = asm.GetType(typeName);
			MethodInfo mi = asmType.GetMethod(methodName);

			foreach (MethodInfo testMI in asmType.GetMethods())
			{
				Console.WriteLine("\t-->  " + testMI.Name + "\t" + testMI.MetadataToken.ToString("X"));
			}

			MethodBody mb = mi.GetMethodBody();

			byte[] IL = mb.GetILAsByteArray();

			return (IL);
		}

		public static void ResolveMember(byte[] IL)
		{
			int currByte = 0;

			Process current = Process.GetCurrentProcess();
			
			while (currByte < IL.Length)
			{
				switch (IL[currByte])
				{
					// instrukcja wywoania
					case 0x28:
						{
							// pobranie nastpnych czterech instrukcji
							int token = GetTokenFromBytes(IL[++currByte], IL[++currByte], IL[++currByte], IL[++currByte]);

							foreach (Module m in Assembly.GetExecutingAssembly().GetLoadedModules())
							{
								try
								{
									MemberInfo mi = m.ResolveMember(token);
									Console.WriteLine("Zinterpretowano jako: " + mi.Name);
								}
								catch (ArgumentException)
								{
									// nie znaleziono w tym module
								}
							}
							break;
						}
				}
				currByte++;
			}
		}

		public static int GetTokenFromBytes(byte b0, byte b1, byte b2, byte b3)
		{
			Console.WriteLine("\tb0 == " + b0.ToString("X"));
			Console.WriteLine("\tb1 == " + b1.ToString("X"));
			Console.WriteLine("\tb2 == " + b2.ToString("X"));
			Console.WriteLine("\tb3 == " + b3.ToString("X"));
			
			string token = b0.ToString("X");
			token = "0" + b1.ToString("X") + token;
			token = "0" + b2.ToString("X") + token;
			token = "0" + b3.ToString("X") + token;

			Console.WriteLine("Znacznik metadanych (X): " + token.ToString());

			int intToken = int.Parse(token, System.Globalization.NumberStyles.HexNumber);

			Console.WriteLine("Znacznik intToken == " + intToken.ToString("X"));

			return (intToken);
		}


		/*
				-->  DynamicInvocation  06000447
				-->  TestDynamicInvocation      06000448
		  
				00
				28	48	04	00	06
				0
				2A 
		  
		 
				ILDASM
				00  NOP
				28  (06)000448  CALL TestDynamicInvocation()
				00  NOP
				2A  RET
		*/

		/* THE ENQUEUE METHOD IL
			00   |                   nop
			02   |                   ldarg.0
			7B   | (0A)0005DF        ldfld
			03   |                   ldarg.1
			6F   | (0A)0001E1        callvirt
			00   |                   nop
			02   |                   ldarg.0
			7B   | (0A)0005DF        ldfld
			02   |                   ldarg.0
			7B   | (0A)0005E0        ldfld
			6F   | (0A)0005E8        callvirt
			00   |                   nop
			2A   |                   ret
		  
		  THIS METHOD RETURNS
			00
			02
			7B   | E0	05	00	0A
			03
			6F   |	E1	01	00	0A
			0
			2
			7B   |	E0	05	00	0A
			2
			7B   | 	E1	05	00	0A
			6F   | E9	05	00	0A
			0
			2A
		*/
		#endregion
	}
}
